<?php
class AttendanceManager {
    private $conn;
    private $date;
    private $time;
    private $time12;
    private $serial_rfid;
    private $userData = [];
    private $messages = [];
    private $sms_status;
    private $sms_config;
    private $dbname;

    public function __construct($conn, $serial_rfid, $sms_status, $sms_config,$dbname) {
        $this->conn = $conn;
        date_default_timezone_set("Asia/Dhaka");
        $this->time = date("H:i:s");
        $this->time12 = date("h:i A");
        $this->date = date("Y-m-d");
        $this->serial_rfid = hexdec($serial_rfid ?? 0);
        $this->sms_status = $sms_status;
        $this->sms_config = $sms_config;
        $this->dbname =$dbname;
        
    }

    public function process() {
        if (!$this->getServerData() || !$this->getSmsTemplates()) {
            echo "Server or SMS template data missing.";
            return;
        }

        if (!$this->getUserData()) {
            echo $_GET["rfid"] . '#55#notfound#' . date('h:i:sa') . '#' . $this->date;
            return;
        }

        if ($this->checkDuplicateEntry()) {
            $this->handleLeaving();
        } else {
            $this->handleNewEntry();
        }

        $mainName = $this->extractMainName($this->userData['name']);
        echo " " . $mainName . '#55#success#' . date('h:i:sa') . '#' . $this->date;
        
    }

    private function getServerData() {
        $result = $this->conn->query("SELECT * FROM `user` WHERE username='server'");
        if ($result->num_rows > 0) {
            $row = $result->fetch_assoc();
            $this->userData['sender'] = urlencode($row['msgid']);
            $this->userData['accName'] = urlencode($row['accName']);
            return true;
        }
        return false;
    }

    private function getSmsTemplates() {
        $result = $this->conn->query("SELECT * FROM `sms_body`");
        if ($result->num_rows > 0) {
            $row = $result->fetch_assoc();
            $this->messages['present'] = $row['Present SMS'];
            $this->messages['leaving'] = $row['Leaving SMS'];
            return true;
        }
        return false;
    }

    private function getUserData() {
        $sql = "SELECT * FROM `hr` WHERE `rfid`+0 = {$this->serial_rfid}";
        $result = $this->conn->query($sql);
        if ($result->num_rows > 0) {
            $this->userData = array_merge($this->userData, $result->fetch_assoc());
            return true;
        }
        return false;
    }

    private function checkDuplicateEntry() {
        $sql = "SELECT * FROM attendance WHERE `rfid`='{$this->serial_rfid}' AND DATE='{$this->date}'";
        $result = $this->conn->query($sql);
        if ($result->num_rows > 0) {
            $row = $result->fetch_assoc();
            $this->userData['attendance_id'] = $row['id'];
            $this->userData['attendance_time'] = $row['TIME'];
            return true;
        }
        return false;
    }

    private function handleLeaving() {
        $start = strtotime($this->userData['attendance_time']);
        $end = strtotime($this->time);
        $mins = ($end - $start) / 60;

        if ($mins >= 20) {
            $message = $this->formatMessage($this->messages['leaving']);
            if ($this->sms_status === 'ON') {
                $this->sendSms($this->userData['phone'], $message);
            }
            $this->conn->query("UPDATE `attendance` SET `leaving`='{$this->time}' WHERE id='{$this->userData['attendance_id']}'");
        } else {
            echo "Duplicate Entry";
        }
       
    }

private function handleNewEntry() {
    $serial = dechex($this->serial_rfid);
    $sql = "INSERT INTO `attendance`( `rfid`, `serial`, `userID`, `DATE`, `TIME`) 
            VALUES ('{$this->serial_rfid}', '$serial', '{$this->userData['userID']}', '{$this->date}', '{$this->time}')";
    
    // Added missing closing parenthesis after query() call
    if ($this->conn->query($sql) === TRUE) {
        $message = $this->formatMessage($this->messages['present']);
        if ($this->sms_status === 'ON') {
            $this->sendSms($this->userData['phone'], $message);
        }
    }
}

    private function formatMessage($template) {
        $message = str_replace(
            ["[STUDENT_NAME]", "[ACADEMY_NAME]", "[DATE]", "[TIME]"],
            [$this->userData['name'], urldecode($this->userData['accName']), $this->date, $this->time12],
            $template
        );
        return trim($message);
    }

    private function extractMainName($name) {
        $parts = explode(" ", str_replace(".", " ", $name));
        foreach ($parts as $part) {
            if (strlen($part) > 2) return $part;
        }
        return $name;
    }

    private function sendSms($number, $message) {
        
        if ($this->sms_config === 'Greenweb') {
$short_url = $this->shortenWithTinyURL($number, $this->userData['userID']);
$message.=" Download the app ".$short_url;
            $token = "29820043381729363418be5f9e7d59aaf916c2868b3f2a85b41a";        
            $url = "https://api.bdbulksms.net/api.php?json";
            $data = array(
                'to' => "$number",
                'message' => "$message",
                'token' => "$token"
            ); 
            $ch = curl_init(); 
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
            curl_setopt($ch, CURLOPT_ENCODING, '');
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $smsresult = curl_exec($ch);
            
            $this->storeMessage($number, $message, '3rdParty');
        } elseif ($this->sms_config === 'Amartable') {
            $this->storeMessage($number, $message, 'Amartable');
        }
    }

    private function storeMessage($number, $message, $status) {
        $servername = "localhost";
        $username = "amartabl_user";
        $password = "Bangladesh@1971";
        $dbname = "amartabl_msgserver";
        
        $msg_conn = new mysqli($servername, $username, $password, $dbname);
        if ($msg_conn->connect_error) {
            error_log("Message server connection failed: " . $msg_conn->connect_error);
            return;
        }
        
        $stmt = $msg_conn->prepare("INSERT INTO `message`(`Date`, `Number`, `Content`, `sended_time`, `sender`, `Status`) VALUES (?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("ssssss", $this->date, $number, $message, date("h:i:sa"), urldecode($this->userData['sender']), $status);
        $stmt->execute();
        $stmt->close();
        $msg_conn->close();
    }
   private function shortenWithTinyURL($number, $student_id, $password = 'securepass') {
    // Construct the original URL
    $db = str_replace("amartable_", "", $this->dbname);

    $long_url = "https://app.amartable.com/setup/index.php?institution=$db&phone=$number&student_id=$student_id&password=$password";

    // Encode the URL
    $encoded_url = urlencode($long_url);

    // TinyURL API call
    $api_url = "https://tinyurl.com/api-create.php?url=" . $encoded_url;

    // Get and return the shortened URL
    return file_get_contents($api_url);
}
}
?>