<?php

class Database
{
    private $host = servername;
    private $user = username;  // Change this if needed
    private $pass = password;      // Change this if needed
    private $dbname = database;
    private $conn;

    public function __construct()
    {
        $this->conn = new mysqli($this->host, $this->user, $this->pass, $this->dbname);

        if ($this->conn->connect_error) {
            die("Database connection failed: " . $this->conn->connect_error);
        }
    }

    public function getConnection()
    {
        return $this->conn;
    }
        // ✅ New function to get database_name by device_name
    public function getDatabaseNameByDevice($deviceName)
    {
        $stmt = $this->conn->prepare("SELECT * FROM rfid_devices WHERE device_name = ?");
        $stmt->bind_param("s", $deviceName);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($row = $result->fetch_assoc()) {
            return $row;
        } else {
            return null;
        }
    }
}
?>
