<?php

class RFIDDatabaseManager
{
    private $host = servername;  // Update with your actual host
    private $user = username;   // Update with your actual username
    private $pass = password;   // Update with your actual password
    private $dbname;
    private $conn;

    public function __construct($databaseName)
    {
        $this->dbname = $databaseName;
        $this->conn = new mysqli($this->host, $this->user, $this->pass, $this->dbname);

        if ($this->conn->connect_error) {
            die("Database connection failed: " . $this->conn->connect_error);
        }
    }

    public function getConnection()
    {
        return $this->conn;
    }

    // ✅ Function to get database_name by device_name
    public function getUserName($rfid)
    { $rfid=(int)$rfid;

        $stmt = $this->conn->prepare("SELECT `userID`, `name`, `subject`, `rfid`, `phone`, `occupation` FROM `hr` WHERE rfid+0= ?");
        $stmt->bind_param("s", $rfid);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($row = $result->fetch_assoc()) {
            
            return $row['name'];
        } else {
            return null;
        }
    }
}
?>
